package org.msh.tb.bd.tbforms.input;

import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.msh.tb.entities.enums.TbFormField;

import java.util.Map;

/**
 * Created by Mauricio on 25/02/2017.
 * Specification that implements TB 10 form input
 */
@Name("tb10InputFormHome")
public class Tb10InputFormHome extends InputFormHome {

    @In(create=true) protected Map<String, String> messages;

    private TB10InputFormData data;

    private final TbFormField[] fields = new TbFormField[] {
            TbFormField.TB10_BLOCK3_FIELD1,
            TbFormField.TB10_BLOCK3_FIELD2,
            TbFormField.TB10_BLOCK3_FIELD3,
            TbFormField.TB10_BLOCK3_FIELD4,
            TbFormField.TB10_BLOCK4_FIELD1,
            TbFormField.TB10_BLOCK4_FIELD2,
            TbFormField.TB10_BLOCK4_FIELD3,
            TbFormField.TB10_BLOCK4_FIELD4,
            TbFormField.TB10_BLOCK5B_FIELD1,
            TbFormField.TB10_BLOCK5B_FIELD2,
            TbFormField.TB10_BLOCK5B_FIELD3,
            TbFormField.TB10_BLOCK5B_FIELD4,
            TbFormField.TB10_BLOCK6A_FIELD1,
            TbFormField.TB10_BLOCK6A_FIELD2,
            TbFormField.TB10_BLOCK6B_FIELD1,
            TbFormField.TB10_BLOCK6B_FIELD2,
            TbFormField.TB10_BLOCK6C_FIELD1,
            TbFormField.TB10_BLOCK6C_FIELD2,
            TbFormField.TB10_TOTAL_CASES_PRESENTED_MANUALLY
    };

    /**
     * @return an array containing the fields of the report in question
     */
    @Override
    protected TbFormField[] getFields() {
        return fields;
    }

    /**
     * @return the report name to be set on transaction log
     */
    @Override
    protected String getReportName() {
        return messages.get("manag.tbform10");
    }

    /**
     * @return the DTO class that stores the values
     */
    @Override
    public TB10InputFormData getData() {
        if (this.data == null) {
            this.data = new TB10InputFormData();
        }
        return data;
    }
}
